package cn.com.duiba.duixintong.center.api.enums.hologres;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chenyongkun
 * @date 2023/6/9
 */
@Getter
@AllArgsConstructor
public enum HologresDimensionEnum {
    //银行ID
    BANK_ID("bank_id", "bankId", "int", "银行ID"),
    //渠道
    BANK_CHANNEL("bank_channel", "bankChannel", "int", "渠道"),

    //商家ID
    BUSINESS_ID("business_id", "businessId", "int", "商家ID"),

    //状态
    CARD_STATUS("card_status", "cardStatus", "int", "状态"),


    ACTIVITY_ID("activity_id", "activityId", "int", "活动ID"),


    USER_ID("user_id", "userId", "int", "用户ID"),

    REFERENCE_USER_ID("reference_user_id", "referenceUserId", "int", "推荐人用户id"),

    EQUITY_ID("equity_id", "equityId", "int", "权益id"),

    STATUS("status", "status", "int", "权益订单状态"),
    GMT_CREATE("gmt_create", "gmtCreate", "int", "创建时间"),
    GMT_MODIFIED("gmt_modified", "gmtModified", "int", "更新时间"),

    ;


    /**
     * 表定义的字段名称
     */
    private final String tableFieldName;

    /**
     * 结果数据对应的别名
     */
    private final String resultFieldName;

    /**
     * 表中的字段类型(String, int, bigint等等)
     */
    private final String fieldType;

    /**
     * 维度解释说明
     */
    private final String desc;
    
}
