package cn.com.duiba.duixintong.center.api.enums.statistics;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 维度统计，需要查询的数据类型
 * @author lizhi
 * @date 2023/5/28 9:50 AM
 */
@Getter
@AllArgsConstructor
public enum DimensionStatNeedDataTypeEnum {
    ORDER_STATUS_PV(1, "订单状态PV"),
    EQUITY_PV(2, "权益发放PV"),
    ORDER_UN(3, "订单UN"),
    ORDER_UN_REFERENCE_PV(4, "订单UN+推荐人PV"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, DimensionStatNeedDataTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(DimensionStatNeedDataTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static DimensionStatNeedDataTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
    
}
