package cn.com.duiba.duixintong.center.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.es.BankCardOrderEsDto;

import java.util.List;

/**
 * 订单es服务
 * @author lizhi
 * @date 2023/6/9 10:42 AM
 */
@AdvancedFeignClient
public interface RemoteBankCardOrderEsService {

    /**
     * 根据订单号批量查询
     * @param orderNums 订单号集合
     * @return 订单详情
     */
    List<BankCardOrderEsDto> listByOrderNums(List<String> orderNums);

    /**
     * 订单号查询订单(精确查询)
     * @param orderNum 订单号
     * @return 订单详情
     */
    BankCardOrderEsDto getByOrderNum(String orderNum);
}
