/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duixintong.center.api.enums.statistics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DimensionStatisticsEnum {
    BUSINESS(1, "\u5546\u5bb6\u7ef4\u5ea6"),
    BUSINESS_REFERENCE(2, "\u5546\u5bb6+\u63a8\u8350\u4eba\u7ef4\u5ea6"),
    BUSINESS_ACTIVITY(3, "\u5546\u5bb6+\u6d3b\u52a8\u7ef4\u5ea6"),
    REFERENCE_BUSINESS_ACTIVITY(4, "\u5546\u5bb6+\u63a8\u8350\u4eba+\u6d3b\u52a8\u7ef4\u5ea6"),
    IMPORTANT_CUSTOMER(5, "\u91cd\u5ba2\u7ef4\u5ea6"),
    IMPORTANT_CUSTOMER_ACTIVITY(6, "\u91cd\u5ba2+\u6d3b\u52a8\u7ef4\u5ea6");

    private final Integer dimension;
    private final String desc;
    public static final Set<DimensionStatisticsEnum> ORDER_STAT_DIMENSION_SET;
    public static final Set<DimensionStatisticsEnum> CUSTOMER_STAT_DIMENSION_SET;
    public static final Set<DimensionStatisticsEnum> EQUITY_STAT_DIMENSION_SET;
    public static final Set<DimensionStatisticsEnum> REFERENCE_STAT_DIMENSION_SET;
    private static final Map<Integer, DimensionStatisticsEnum> ENUM_MAP;

    public static DimensionStatisticsEnum getByDimension(Integer dimension) {
        if (dimension == null) {
            return null;
        }
        return ENUM_MAP.get(dimension);
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public String getDesc() {
        return this.desc;
    }

    private DimensionStatisticsEnum(Integer dimension, String desc) {
        this.dimension = dimension;
        this.desc = desc;
    }

    static {
        ORDER_STAT_DIMENSION_SET = Collections.unmodifiableSet(Arrays.stream(DimensionStatisticsEnum.values()).collect(Collectors.toSet()));
        CUSTOMER_STAT_DIMENSION_SET = Collections.unmodifiableSet(Stream.of(BUSINESS, BUSINESS_REFERENCE, IMPORTANT_CUSTOMER).collect(Collectors.toSet()));
        EQUITY_STAT_DIMENSION_SET = Collections.unmodifiableSet(Stream.of(BUSINESS, BUSINESS_REFERENCE, IMPORTANT_CUSTOMER).collect(Collectors.toSet()));
        REFERENCE_STAT_DIMENSION_SET = Collections.unmodifiableSet(Stream.of(BUSINESS).collect(Collectors.toSet()));
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(DimensionStatisticsEnum.values()).collect(Collectors.toMap(DimensionStatisticsEnum::getDimension, Function.identity(), (v1, v2) -> v2)));
    }
}

