package cn.com.duiba.duixintong.center.api.param.register;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 注册重客
 * @author lizhi
 * @date 2023/6/30 5:55 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class RegisterImportantParam extends BaseRegisterParam {
    
    private static final long serialVersionUID = -2847195122652762258L;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-银行，2-财产险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum#getChannel()
     */
    private Integer bankChannel;

    /**
     * 重客编码
     */
    private String customerCode;

    /**
     * 姓名
     */
    private String userName;

    /**
     * 银行scc码
     */
    private String bankScc;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 手机号
     */
    private String userPhone;
}
