package cn.com.duiba.duixintong.center.api.remoteservice.important;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.important.ImportantCustomerDto;

/**
 * 重客
 * @author lizhi
 * @date 2023/6/28 4:41 PM
 */
@AdvancedFeignClient
public interface RemoteImportantCustomerService {

    /**
     * 根据账号查询
     * @param accountNum 账号
     * @return 重客
     */
    ImportantCustomerDto selectByAccountNum(String accountNum);

    /**
     * 根据重客编码查询
     * @param customerCode 重客编码
     * @return 重客
     */
    ImportantCustomerDto selectByCustomerCode(String customerCode);

    /**
     * 根据id查询
     * @param id 账号
     * @return 重客
     */
    ImportantCustomerDto selectById(Long id);
}
