package cn.com.duiba.duixintong.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.order.UserEquityStatusRecordDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteUserEquityStatusRecordService {

	int save(UserEquityStatusRecordDto userEquityStatusRecordDto);

    int updateById(UserEquityStatusRecordDto userEquityStatusRecordDto);

    UserEquityStatusRecordDto getById(Long id);

    List<UserEquityStatusRecordDto> listByIds(List<Long> ids);

    /**
     * 查询权益状态变更时间
     * @param userEquityIds 用户权益发放主键集合
     * @return key：用户权益发放主键，key：状态，value：创建时间
     */
    Map<Long, Map<Integer, Date>> selectStatusTimeMap(List<Long> userEquityIds);

}
