package cn.com.duiba.duixintong.center.api.enums.account;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 账号类型
 * @author lizhi
 * @date 2023/5/15 5:39 PM
 */
@Getter
@AllArgsConstructor
public enum AccountTypeEnum {
    ROOT(1, "超级管理员"),
    BUSINESS(2, "商家账号"),
    COMMISSIONER(3, "专员账号"),
    IMPORTANT_CUSTOMER(4, "重客账号"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, AccountTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(AccountTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static AccountTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
