package cn.com.duiba.duixintong.center.api.param.fund;

import cn.com.duiba.biz.tool.duiba.dto.page.PageQuery;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 
 * @author lizhi
 * @date 2023/6/8 7:29 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class FundAccountChangeRecordParam extends PageRequest {
    
    private static final long serialVersionUID = 6410027351199252598L;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum}
     */
    private Integer accountType;

    /**
     * 商家ID，用于商家维度分页查询
     */
    private Long businessId;

    /**
     * 变更类型，1-支出, 2-收入
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountChangeTypeEnum}
     */
    private Integer changeType;

    /**
     * 业务类型，1-提现，2-提现失败回退，3-重客分佣，4-商家分佣，5-推荐人分佣
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountBizTypeEnum}
     */
    private List<Integer> bizTypeList;
}
