package cn.com.duiba.duixintong.center.api.utils;

import cn.com.duiba.duixintong.center.api.enums.statistics.DateTypeEnum;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

/**
 * @author pengyi
 * @date 2023/5/23 10:56
 */
public class DateUtils {
    
    private DateUtils() {}

    private static final SimpleDateFormat ONLY_MONTH = getFormat("MM");

    private static final SimpleDateFormat ONLY_DAY = getFormat("dd");

    private static final SimpleDateFormat ONLY_HOUR = getFormat("HH");

    private static final SimpleDateFormat LONG_MONTH = getFormat("yyyyMM");

    private static final SimpleDateFormat LONG_DAY = getFormat("yyyyMMdd");

    private static final SimpleDateFormat LONG_HOUR = getFormat("yyyyMMddHH");


    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    public static String getOnlyHourStr(Date date) {
        synchronized (ONLY_HOUR) {
            return getStr(date, ONLY_HOUR);
        }
    }

    public static String getOnlyDayStr(Date date) {
        synchronized (ONLY_DAY) {
            return getStr(date, ONLY_DAY);
        }
    }

    public static String getOnlyMonthStr(Date date) {
        synchronized (ONLY_MONTH) {
            return getStr(date, ONLY_MONTH);
        }
    }

    public static String getLongHourStr(Date date) {
        synchronized (LONG_HOUR) {
            return getStr(date, LONG_HOUR);
        }
    }

    public static String getLongDayStr(Date date) {
        synchronized (LONG_DAY) {
            return getStr(date, LONG_DAY);
        }
    }

    public static String getLongMonthStr(Date date) {
        synchronized (LONG_MONTH) {
            return getStr(date, LONG_MONTH);
        }
    }

    //获取当前月最后一天：
    public static Date getEndDayOfMonth(){
        Calendar cale = Calendar.getInstance();
        cale.add(Calendar.MONTH, 1);
        cale.set(Calendar.DAY_OF_MONTH, 0);
        cale.set(Calendar.HOUR_OF_DAY,23);
        cale.set(Calendar.MINUTE,59);
        cale.set(Calendar.SECOND,59);
        return cale.getTime();
    }

    public static Long getStartTime(DateTypeEnum dateType) {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        String dateStr = null;
        // 当日开始时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            Date dayStartTime = cn.com.duiba.wolf.utils.DateUtils.getDayStartTime(new Date());
            dateStr = DateUtils.getLongHourStr(dayStartTime);
        }
        // 当月第一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            Date monthFirstDay = cn.com.duiba.wolf.utils.DateUtils.getMonthDayByIndex(new Date(), 1);
            dateStr = DateUtils.getLongDayStr(monthFirstDay);
        }
        if (StringUtils.isNotBlank(dateStr)) {
            return Long.valueOf(dateStr);
        }
        return null;
    }

    public static Long getEndTime(DateTypeEnum dateType) {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        String dateStr = null;
        // 当日23:59:59时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            Date dayEndTime = cn.com.duiba.wolf.utils.DateUtils.getDayEndTime(new Date());
            dateStr = DateUtils.getLongHourStr(dayEndTime);
        }
        // 当月最后一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            Date endDayOfMonth = DateUtils.getEndDayOfMonth();
            dateStr = cn.com.duiba.duixintong.center.api.utils.DateUtils.getLongDayStr(endDayOfMonth);
        }
        if (StringUtils.isNotBlank(dateStr)) {
            return Long.valueOf(dateStr);
        }
        return null;
    }

    public static Date getStartDate(DateTypeEnum dateType) {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        // 当日开始时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            return cn.com.duiba.wolf.utils.DateUtils.getDayStartTime(new Date());
        }
        // 当月第一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            Date monthFirstDay = cn.com.duiba.wolf.utils.DateUtils.getMonthDayByIndex(new Date(), 1);
            return cn.com.duiba.wolf.utils.DateUtils.getDayStartTime(monthFirstDay);
        }
        return null;
    }

    public static Date getEndDate(DateTypeEnum dateType) {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        // 当日23:59:59时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            return cn.com.duiba.wolf.utils.DateUtils.getDayEndTime(new Date());
        }
        // 当月最后一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            return getEndDayOfMonth();
        }
        return null;
    }

    public static String getTimeStr(DateTypeEnum typeEnum, Long time) {
        String timeStr = String.valueOf(time);
        timeStr = timeStr.substring(timeStr.length() - 2);
        if (Objects.equals(typeEnum, DateTypeEnum.DAY)) {
            return  timeStr + "时";
        }
        if (Objects.equals(typeEnum, DateTypeEnum.MONTH)) {
            return timeStr + "日";
        }
        if (Objects.equals(typeEnum, DateTypeEnum.ALL)) {
            return timeStr + "月";
        }
        return null;
    }

    /**
     * 获取下一月最后一天 23点59分59秒 时间搓
     */
    public static long getNextMonthLastDayTimeInMillis(Date date){
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, 2);
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return calendar.getTimeInMillis();
    }
}
