package cn.com.duiba.game.center.api.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * Created by sty on 2018/8/31.
 */
public enum NGameRankTypeEnum {

  TOTAL_RANK(0, "总排行榜"),
  DAILY_RANK(1, "当日排行榜"),
  MULTI_TOTAL_RANK(2, "多游戏总排行榜"),
  YESTERDAY_RANK(3, "昨日排行榜"),
  OPTION_RANK(4, "多奖项排行"),
  WEEKLY_RANK(5, "周排行榜"),
  LAST_WEEKLY_RANK(6, "上周排行榜"),
  ;

  private static final Map<Integer, NGameRankTypeEnum> ALL_MAP = Maps.newHashMap();
  private static final List<NGameRankTypeEnum> ALL = Lists.newArrayList(values());

  static {
    ALL.forEach(e -> ALL_MAP.put(e.getCode(), e));
  }

  /** 排行榜类型代码 */
  private Integer code;
  /** 描述 */
  private String desc;

  NGameRankTypeEnum(Integer code, String desc) {
    this.code = code;
    this.desc = desc;
  }


  public static List<NGameRankTypeEnum> getAll() {
    return ALL;
  }

  public Integer getCode() {
    return code;
  }

  public String getDesc() {
    return desc;
  }
}
