/**
 * Project Name:goods-center-api
 * File Name:RemotePCGGoodsService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月27日下午5:57:03
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import java.util.Date;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGGoodsService <br/>
 * Function: 平台券前台服务 <br/>
 * Date:     2016年6月27日 下午5:57:03 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemotePCGGoodsService {
    /**
     * 
     * 检查平台券商品是否有库存 <br/>
     * 总库存，预分配库存，每日限量库存
     * @author xuhengfei
     * @param pcgId
     * @param appId
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> checkStockEnough(long pcgId,long appId,long consumerId);
    /**
     * 
     * 查询平台券商品的积分消耗值 <br/>
     * 定向设置积分，正常换算积分
     * @author xuhengfei
     * @param pcgId
     * @param appId
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> calcultePCGCredits(long pcgId,long appId,long consumerId);
    
    DubboResult<Boolean> canTakePlatformCouponGoods(long pcgId,long appId,long consumerId);
    /**
     * 
     * 下单一张平台券 <br/>
     * @author xuhengfei
     * @param pcgId 平台券商品id
     * @param appId 
     * @param consumerId
     * @param orderNum 订单号
     * @return 平台券couponId
     * @since JDK 1.6
     */
    DubboResult<Long> takePlatformCouponGoods(long pcgId,long appId,long consumerId,String orderNum);
    /**
     * 回滚一个平台优惠劵
     *
     * @author xuhengfei
     * @param pcgId
     * @param consumerId
     * @param couponId
     * @param orderNum
     * @since JDK 1.6
     */
    void rollbackPCGCoupon(long pcgId,long consumerId,long couponId,String orderNum);
    
}

