/**
 * Project Name:goods-center-api
 * File Name:RemotePCGFilterConfigBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月19日下午8:09:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGFilterConfigBackendService <br/>
 * Function: App的黑名单管理服务 <br/>
 * Date:     2016年5月19日 下午8:09:48 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemotePCGFilterConfigBackendService {
    /**
     * 
     * addCategoryBlackList:添加一条类目黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId
     * @param categoryId 类目id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addCategoryBlackList(Long appId,Long categoryId);
    /**
     * 
     * deleteCategoryBlackList:删除一条类目黑名单 <br/>
     *
     * @author xuhengfei
     * @param appId
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteCategoryBlackList(Long appId,Long categoryId);
    
    /**
     * 
     * addSellerBlackList:添加一条品牌黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId
     * @param sellerId 品牌id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addSellerBlackList(Long appId,Long sellerId);
    /**
     * 
     * deleteSellerBlackList:删除一条品牌黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId
     * @param sellerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteSellerBlackList(Long appId,Long sellerId);
    /**
     * 
     * addGoodsBlackList:添加一条针对商品的黑名单 <br/>
     *
     * @author xuhengfei
     * @param appId
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addGoodsBlackList(Long appId,Long pcgId);
    /**
     * 
     * deleteGoodsBlackList:删除一条针对商品的黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteGoodsBlackList(Long appId,Long pcgId);
    /**
     * 
     * findMyList:查询App的所有黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<PCGFilterConfigDto> findMyList(Long appId);
}

