/**
 * Project Name:goods-center-api
 * File Name:RemotePCGSellerBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月19日下午8:05:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGSellerBackendService <br/>
 * Function: PCG 品牌黑名单维护服务 <br/>
 * Date:     2016年5月19日 下午8:05:28 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemotePCGSellerBackendService {
    
    /**
     * 
     * createSeller:创建一个品牌 <br/>
     *
     * @author xuhengfei
     * @param seller
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> createSeller(String name,String logo);
    /**
     * 
     * findAll:查询所有品牌 <br/>
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<PCGSellerDto>> findAll();
    
    
    /**
     * 设置商品到一个品牌
     *
     * @author xuhengfei
     * @param pcgId
     * @param sellerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addGoods2Seller(long pcgId,long sellerId);
    /**
     * 将商品从一个品牌中删除
     *
     * @author xuhengfei
     * @param pcgId
     * @param sellerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> remoteGoodsFromSeller(long pcgId,long sellerId);
    
    /**
     * 删除一个品牌
     *
     * @author xuhengfei
     * @param sellerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeSeller(long sellerId);
    
    /**
     * 编辑品牌
     *
     * @author xuhengfei
     * @param categoryId
     * @param name
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> editSellerNameAndLogo(long sellerId,String name,String logo);
    /**
     * 对分类进行排序(只更新payload字段，不更新其他字段)
     *
     * @author xuhengfei
     * @param categories
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortSellers(List<PCGSellerDto> sellers);
    
    /**
     * 查找一个品牌下的所有商品
     *
     * @author xuhengfei
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<PCGSellerGoodsDto>> findAllBySellerId(long selllerId);
    /**
     * 对一个品牌下的商品进行排序
     *
     * @author xuhengfei
     * @param list
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortSellerGoods(List<PCGSellerGoodsDto> list);
    
}

