/**
 * Project Name:goods-center-api
 * File Name:PlatformCouponGoodsDTO.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月19日下午4:01:07
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:PCGDto <br/>
 * Function: 平台券的商品信息DTO. <br/>
 * Date:     2016年5月19日 下午4:01:07 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class PCGDto implements Serializable{

    private static final long serialVersionUID = 1L;
    

    private Long pcgId;
    
    private String title;
    
    private String name;
    
    private String subtitle;
    
    private Integer minPrice;
    
    private String usePrompt;
    
    private String buttonText;
    
    private Integer interestPrice;
    
    private String interestDesc;
    
    private String backgroundColor;
    
    private String iconImage;
    
    private String thumbnailImage;
    
    private String detailImage;
    
    private Integer couponType;
    
    private Date autoOffDate;
    
    private Long switches;
    
    private Integer pcgStatus;
    
    private Boolean deleted;
    
    private Date gmtCreate;
    
    private Date gmtModified;
    
    private String detail;//描述详情信息
    
    private Integer limitPerConsumer;
    
    private Long stock;//目前剩余库存
    
    private Long totalStock;//总库存

    
    public Long getPcgId() {
        return pcgId;
    }

    
    public void setPcgId(Long pcgId) {
        this.pcgId = pcgId;
    }

    
    public String getTitle() {
        return title;
    }

    
    public void setTitle(String title) {
        this.title = title;
    }

    
    public String getName() {
        return name;
    }

    
    public void setName(String name) {
        this.name = name;
    }

    
    public String getSubtitle() {
        return subtitle;
    }

    
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    
    public Integer getMinPrice() {
        return minPrice;
    }

    
    public void setMinPrice(Integer minPrice) {
        this.minPrice = minPrice;
    }

    
    public String getUsePrompt() {
        return usePrompt;
    }

    
    public void setUsePrompt(String usePrompt) {
        this.usePrompt = usePrompt;
    }

    
    public String getButtonText() {
        return buttonText;
    }

    
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    
    public Integer getInterestPrice() {
        return interestPrice;
    }

    
    public void setInterestPrice(Integer interestPrice) {
        this.interestPrice = interestPrice;
    }

    
    public String getInterestDesc() {
        return interestDesc;
    }

    
    public void setInterestDesc(String interestDesc) {
        this.interestDesc = interestDesc;
    }

    
    public String getBackgroundColor() {
        return backgroundColor;
    }

    
    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    
    public String getIconImage() {
        return iconImage;
    }

    
    public void setIconImage(String iconImage) {
        this.iconImage = iconImage;
    }

    
    public String getThumbnailImage() {
        return thumbnailImage;
    }

    
    public void setThumbnailImage(String thumbnailImage) {
        this.thumbnailImage = thumbnailImage;
    }

    
    public String getDetailImage() {
        return detailImage;
    }

    
    public void setDetailImage(String detailImage) {
        this.detailImage = detailImage;
    }

    
    public Integer getCouponType() {
        return couponType;
    }

    
    public void setCouponType(Integer couponType) {
        this.couponType = couponType;
    }

    
    public Date getAutoOffDate() {
        return autoOffDate;
    }

    
    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    
    public Long getSwitches() {
        return switches;
    }

    
    public void setSwitches(Long switches) {
        this.switches = switches;
    }

    
    public Integer getPcgStatus() {
        return pcgStatus;
    }

    
    public void setPcgStatus(Integer pcgStatus) {
        this.pcgStatus = pcgStatus;
    }

    
    public Boolean getDeleted() {
        return deleted;
    }

    
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    
    public Date getGmtCreate() {
        return gmtCreate;
    }

    
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    
    public Date getGmtModified() {
        return gmtModified;
    }

    
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    
    public static long getSerialversionuid() {
        return serialVersionUID;
    }


    
    public String getDetail() {
        return detail;
    }


    
    public void setDetail(String detail) {
        this.detail = detail;
    }


    
    public Integer getLimitPerConsumer() {
        return limitPerConsumer;
    }


    
    public void setLimitPerConsumer(Integer limitPerConsumer) {
        this.limitPerConsumer = limitPerConsumer;
    }


    
    public Long getStock() {
        return stock;
    }


    
    public void setStock(Long stock) {
        this.stock = stock;
    }


    
    public Long getTotalStock() {
        return totalStock;
    }


    
    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }


}

