/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsCouponService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年5月24日下午4:19:45
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGoodsCouponService <br/>
 * Function: 前台服务，提供发券和还券操作 <br/>
 * Date:     2016年5月24日 下午4:19:45 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsCouponService {
    /**
     * 领一张优惠劵
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param consumerId
     * @param bizNum
     * @return
     * @since JDK 1.6
     */
    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype,long gid,long consumerId,String bizNum);
    /**
     * 完成一张优惠劵的领取
     * @author xuhengfei
     * @param couponId
     * @param orderId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> completeCoupon(Long couponId,long orderId);
    /**
     * 将一张已经领取但未完成的优惠劵重置为未领取(订单失败，返还优惠劵)
     *
     * @author xuhengfei
     * @param couponId
     * @param bizNum
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> rollbackCoupon(Long couponId,String bizNum);
    
    /**
     * 根据券码ID查询券码DTO
     * @author houwen
     * @param gtype GTYPE
     * @param gid GID
     * @param couponId 券码ID
     * @return
     */
    public DubboResult<GoodsCouponDto> findCoupon(GoodsTypeEnum gtype,long gid, Long couponId);
    
    /**
     * 查询当前使用中的批次信息（前台用户展示过期开始结束时间）
     * @param gtype
     * @param gid
     * @return
     */
    public DubboResult<GoodsBatchDto> findUsingBatch(GoodsTypeEnum gtype,long gid);
    
    /**
     * 查询商品当前批次库存
     * @author houwen
     * @param gtype
     * @param gid
     * @return
     */
    public DubboResult<Long> findCurrentBatchStock(GoodsTypeEnum gtype,long gid);
    
    /**
     * 批量查询商品当前批次库存
     * @author houwen
     * @param goods
     * @return
     */
    public DubboResult<List<GoodsStockDto>> findCurrentBatchStockByBatch(List<GoodsStockDto> goods);
}

