/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsCouponBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月23日上午10:48:53
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import java.util.Date;
import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchImportLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGoodsCouponBackendService <br/>
 * Function: 券码库，后台调用服务 <br/>
 * Date:     2016年5月23日 上午10:48:53 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsCouponBackendService {
    /**
     * 
     * createNormalBatch:创建一个普通的优惠券批次. <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param start 有效期开始时间
     * @param end  有效期截止时间
     * @return 批次id
     * @since JDK 1.6
     */
    public DubboResult<Long> createNormalBatch(GoodsTypeEnum gtype,long gid,Date start,Date end);
    
    public DubboResult<Long> createLinkBatch(GoodsTypeEnum gtype,long gid,Date start,Date end,String link,long stock);
     
    public DubboResult<Long> createRepeatBatch(GoodsTypeEnum gtype,long gid,Date start,Date end,String code,String password,long stock);
     
    public DubboResult<Boolean> updateLinkBatch(GoodsTypeEnum gtype,long gid,Long batchId,String link,long changeStock);
     
    public DubboResult<Boolean> updateRepeatBatch(GoodsTypeEnum gtype,long gid,Long batchId,String code,String password,long changeStock);
     
    public DubboResult<List<GoodsBatchDto>> findBatchs(GoodsTypeEnum gtype,long gid);
    /**
     * 
     * importNormalCoupons:导入普通券码 <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchId
     * @param downloadUrl 券码附件的下载地址
     * @return 导入券码的日志id，通过此id再调用 findBatchImportLog 来查询进度和结果
     * @since JDK 1.6
     */
    public DubboResult<Long> importNormalCoupons(GoodsTypeEnum gtype,long gid,Long batchId,String downloadUrl);
    /**
     * 查询导入的进度个结果
     *
     * @author xuhengfei
     * @param goodsBatchImportLogId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<GoodsBatchImportLogDto> findBatchImportLog(Long goodsBatchImportLogId);
    
    public DubboResult<Boolean> deleteBatch(GoodsTypeEnum gtype,long gid,Long batchId);//逻辑删除
    
    public DubboResult<Page<GoodsCouponDto>> findPage(GoodsTypeEnum gtype,long gid,long batchId,int pageSize,int pageIndex);
    
    public DubboResult<GoodsBatchDto> findBatchStock(GoodsTypeEnum gtype,long gid,long batchId);
    /**
     * 根据券码查询 某个批次下的优惠劵
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchId
     * @param code
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<GoodsCouponDto>> findCouponByCode(GoodsTypeEnum gtype,long gid,long batchId,String code);
    
}

