/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsCouponService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年5月24日下午4:19:45
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGoodsCouponService <br/>
 * Function: 前台服务，提供发券和还券操作 <br/>
 * Date:     2016年5月24日 下午4:19:45 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsCouponService {

    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype,long gid,long consumerId,String bizNum);
    
    public DubboResult<Boolean> completeCoupon(Long couponId,long orderId);
    
    public DubboResult<Boolean> rollbackCoupon(Long couponId,String bizNum);
    
    public GoodsCouponDto findCoupon(long couponId);
    
}

