/**
 * Project Name:goods-center-api
 * File Name:RemotePCGGoodsInfoService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月29日下午8:53:46
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGGoodsInfoService <br/>
 * Function: 平台券商品信息查询. <br/>
 * Date:     2016年6月29日 下午8:53:46 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemotePCGGoodsInfoService {
    
    public PCGDto find(long pcgId);
    /**
     * 
     * findCategoryAll:查询所有的分类 <br/>
     *
     * @author zhengjy
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<PCGCategoryDto>> findCategoryAll();
    /**
     * 
     * findSellerAll:查询所有品牌 <br/>
     *
     * @author zhengjy
     * @return
     *14 @since JDK 1.6
     */
    DubboResult<List<PCGSellerDto>> findSellerAll();
    
   
    /**
     * 查询app下屏蔽分类，品牌或商品 <br/>
     * @param appId 
     * @param type  type  1:优惠券 2:分类 3:品牌
     * @return
     */
    DubboResult<List<Long>>  findPCGFilterTargetIds(Long appId,Integer type);
    
    /**
     * 查询分类下商品列表<br/>
     * @param appId
     * @param consumerId 用户id
     * @param consumerCredits 用户积分
     * @param devRate 开发者汇率
     * @param pageIndex
     * @param pageSize
     * @return
     */
    DubboResult<Page<PCGCategorySellerGoodsDto>> findCategoryGoods(long appId,long categoryId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize);
    
    /**
     * 查询品牌下商品列表<br/>
     * @param appId
     * @param consumerId 用户id
     * @param consumerCredits 用户积分
     * @param devRate 开发者汇率
     * @param pageIndex
     * @param pageSize
     * @return
     */
    DubboResult<Page<PCGCategorySellerGoodsDto>> findSellerGoods(long appId,long sellerId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize);
    
    /**
     * 查询平台券详细信息 （包括 兑换状态）<br/>
     * @param appId
     * @param gid 平台券id
     * @param consumerId 用户id
     * @param consumerCredits 用户积分
     * @return
     */
    DubboResult<PCGCategorySellerGoodsDto> findSellerGoodsInfo(long appId,long gid,Long consumerId,Long consumerCredits);
}

