/**
 * Project Name:goods-center-api File Name:RemoteAdvertCouponGoodsBackendService.java Package
 * Name:cn.com.duiba.goods.center.api.remoteservice Date:2016年7月13日下午8:13:34 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.goods.center.api.remoteservice.dto.AdvertCouponGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAdvertCouponGoodsBackendService <br/>
 * Function: 广告优惠卷商品Service. <br/>
 * Date: 2016年7月13日 下午8:13:34 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@SuppressWarnings("deprecation")
public interface RemoteAdvertCouponGoodsBackendService {

    /**
     * 创建广告卷商品.
     *
     * @param goods the goods
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> createAdvertCouponGoods(AdvertCouponGoodsDto goods);

    /**
     * 修改广告卷商品.
     *
     * @param acgId 优惠卷ID
     * @param goods the goods
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> editAdvertCouponGoods(Long acgId, AdvertCouponGoodsDto goods);

    /**
     * 删除广告卷(逻辑删除).
     *
     * @param acgId 优惠卷ID
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> deleteGoods(Long acgId);

    /**
     * 查询广告卷信息.
     *
     * @param acgId 优惠卷ID
     * @return the dubbo result< advert coupon goods dto>
     */
    DubboResult<AdvertCouponGoodsDto> find(Long acgId);

    /**
     * 
     * 切换优惠券类型. <br/>
     *
     * @author zufengze
     * @param start 开始日期
     * @param end  结束日期
     * @param code 券码
     * @param password 券码密码
     * @param stock 库存
     * @param link 优惠券链接
     * @param gtype 商品类型
     * @param acgId 商品类型
     * @param dstType 优惠券类型
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> changeACGType(ChangeACGTypeDto t);
    
    

}
