/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsCouponService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年5月24日下午4:19:45
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGoodsCouponService <br/>
 * Function: 前台服务，提供发券和还券操作 <br/>
 * Date:     2016年5月24日 下午4:19:45 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsCouponService {
    /**
     * 领一张券
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param consumerId 用户id
     * @param bizNum 业务编号
     * @return 券信息
     * @since JDK 1.6
     */
    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype,long gid,long consumerId,String bizNum);
    /**
     * 确认完成一张券(在订单最终成功时来调用此方法)
     *
     * @author xuhengfei
     * @param couponId 券号
     * @param orderId 订单id
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> completeCoupon(Long couponId,long orderId);
    /**
     * 回滚一张券<br/>
     * 如果先锁定一张券，最终订单失败了，需要调用此方法，将券回滚为 未使用  状态
     *
     * @author xuhengfei
     * @param couponId 券号
     * @param bizNum 业务编号
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> rollbackCoupon(Long couponId,String bizNum);
    /**
     * 查询一张券信息
     *
     * @author xuhengfei
     * @param couponId 券号
     * @return 券信息
     * @since JDK 1.6
     */
    public GoodsCouponDto findCoupon(long couponId);



}

