/**
 * Project Name:goods-center-api File Name:AdvertCouponGoodsDto.java Package
 * Name:cn.com.duiba.goods.center.api.remoteservice.dto Date:2016年7月13日下午8:15:02 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.goods.center.api.remoteservice.dto;

import java.io.Serializable;

/**
 * ClassName:AdvertCouponGoodsDto <br/>
 * Function: 广告券商品Dto类 <br/>
 * Date: 2016年7月13日 上午10:39:25 <br/>
 * 
 * @author sunjiangrong
 * @version
 * @since JDK 1.6
 * @see
 */
public class AdvertCouponGoodsDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 4373488239980114028L;

    /** 优惠卷id. */
    private long              acgId;

    /** 推广网址. */
    private String            promoteURL;

    /** 商品名称. */
    private String            couponName;

    /** 商品价值(单位为分). */
    private Long              couponPrice;

    /** 商品说明. */
    private String            couponRemark;

    /** 兑换成功文案. */
    private String            exchangeTips;

    /** 一句话描述. */
    private String            description;

    /** 品牌图标. */
    private String            thumbnailPng;

    /** 首页banner图. */
    private String            bannerPng;

    /** 领取次数限制. */
    private Integer           limitReceive;

    /** 优惠码类型. */
    private Integer           couponType;

    /** 是否隐藏. 对特殊应用隐藏使用按钮(0：否，1：是) */
    private boolean           displayMenu;

    /** 是否为微信券. 是否为微信券(0：否，1：是) (只有code_type=2 or code_type=3时有效) */
    private boolean           isWeixin;

    private String            buttonText;


    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public long getAcgId() {
        return acgId;
    }

    public void setAcgId(long acgId) {
        this.acgId = acgId;
    }

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Long couponPrice) {
        this.couponPrice = couponPrice;
    }

    public String getCouponRemark() {
        return couponRemark;
    }

    public void setCouponRemark(String couponRemark) {
        this.couponRemark = couponRemark;
    }

    public String getExchangeTips() {
        return exchangeTips;
    }

    public void setExchangeTips(String exchangeTips) {
        this.exchangeTips = exchangeTips;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public Integer getLimitReceive() {
        return limitReceive;
    }

    public void setLimitReceive(Integer limitReceive) {
        this.limitReceive = limitReceive;
    }

    public Integer getCouponType() {
        return couponType;
    }

    public void setCouponType(Integer couponType) {
        this.couponType = couponType;
    }

    public boolean isDisplayMenu() {
        return displayMenu;
    }

    public void setDisplayMenu(boolean displayMenu) {
        this.displayMenu = displayMenu;
    }

    public boolean isWeixin() {
        return isWeixin;
    }

    public void setWeixin(boolean isWeixin) {
        this.isWeixin = isWeixin;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdvertCouponGoodsDto [acgId=");
        builder.append(acgId);
        builder.append(", promoteURL=");
        builder.append(promoteURL);
        builder.append(", couponName=");
        builder.append(couponName);
        builder.append(", couponPrice=");
        builder.append(couponPrice);
        builder.append(", couponRemark=");
        builder.append(couponRemark);
        builder.append(", exchangeTips=");
        builder.append(exchangeTips);
        builder.append(", description=");
        builder.append(description);
        builder.append(", thumbnailPng=");
        builder.append(thumbnailPng);
        builder.append(", bannerPng=");
        builder.append(bannerPng);
        builder.append(", limitReceive=");
        builder.append(limitReceive);
        builder.append(", couponType=");
        builder.append(couponType);
        builder.append(", displayMenu=");
        builder.append(displayMenu);
        builder.append(", isWeixin=");
        builder.append(isWeixin);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
