/**
 * Project Name:goods-center-api
 * File Name:RemotePCGCategoryBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月19日下午7:58:57
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGCategoryBackendService <br/>
 * Function: 分类管理服务 <br/>
 * Date:     2016年5月19日 下午7:58:57 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@SuppressWarnings("deprecation")
public interface RemotePCGCategoryBackendService {
    /**
     * 创建一个分类
     *
     * @author xuhengfei
     * @param name 分类名称
     * @param payload 权重
     * @return 类目id
     * @since JDK 1.6
     */
    DubboResult<Long> createCategory(String name,Integer payload);
    /**
     * 编辑分类名称
     *
     * @author xuhengfei
     * @param categoryId 类目id
     * @param name 名称
     * @param payload 权重
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> editCategoryNameAndPayload(Long categoryId,String name,Integer payload);
    /**
     * 
     * deleteCategory:删除一个分类 <br/>
     *
     * @author xuhengfei
     * @param categoryId 类目id
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteCategory(Long categoryId);
    /**
     * 
     * findAll:查询所有的分类 <br/>
     *
     * @author xuhengfei
     * @return 结果集
     * @since JDK 1.6
     */
    DubboResult<List<PCGCategoryDto>> findAll();
    /**
     * 对分类进行排序(只更新payload字段，不更新其他字段)
     *
     * @author xuhengfei
     * @param categories 需求更新权重的列表
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortCategories(List<PCGCategoryDto> categories);
    
    /**
     * 向分类下添加一个商品
     * @author xuhengfei
     * @param categoryId 类目id
     * @param pcgId 平台券id
     * @param payload 权重
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> addGoods(long categoryId,long pcgId,Integer payload);
    /**
     * 分类下删除一个商品
     * @author xuhengfei
     * @param categoryId 类目id
     * @param pcgId 平台券商品id
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteGoods(long categoryId,long pcgId);
    /* 内部接口
    DubboResult<Boolean> deleteAllByCategoryId(long categoryId);
    
    DubboResult<Boolean> deleteAllByPcgId(long pcgId);
    */
    /**
     * 查找一个分类下的所有商品
     *
     * @author xuhengfei
     * @param categoryId 类目id
     * @return 结果集
     * @since JDK 1.6
     */
    DubboResult<List<PCGCategoryGoodsDto>> findAllByCategoryId(long categoryId);
    /**
     * 对一个类目下的商品进行排序
     *
     * @author xuhengfei
     * @param list 需要排序的列表
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortCategoryGoods(List<PCGCategoryGoodsDto> list);
}

