/**
 * Project Name:goods-center-api
 * File Name:RemotePCGFilterConfigBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月19日下午8:09:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGFilterConfigBackendService <br/>
 * Function: App的黑名单管理服务 <br/>
 * Date:     2016年5月19日 下午8:09:48 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@SuppressWarnings("deprecation")
public interface RemotePCGFilterConfigBackendService {
    /**
     * 
     * addCategoryBlackList:添加一条类目黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId AppId
     * @param categoryId 类目id
     * @return 记录主键id
     * @since JDK 1.6
     */
    DubboResult<Long> addCategoryBlackList(Long appId,Long categoryId);
    /**
     * 
     * deleteCategoryBlackList:删除一条类目黑名单 <br/>
     *
     * @author xuhengfei
     * @param appId AppId
     * @param categoryId 类目id
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteCategoryBlackList(Long appId,Long categoryId);
    
    /**
     * 
     * addSellerBlackList:添加一条品牌黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId AppId
     * @param sellerId 品牌id
     * @return 记录主键id
     * @since JDK 1.6
     */
    DubboResult<Long> addSellerBlackList(Long appId,Long sellerId);
    /**
     * 
     * deleteSellerBlackList:删除一条品牌黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId AppId
     * @param sellerId 品牌id
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteSellerBlackList(Long appId,Long sellerId);
    /**
     * 
     * addGoodsBlackList:添加一条针对商品的黑名单 <br/>
     *
     * @author xuhengfei
     * @param appId AppId
     * @param pcgId 平台券商品id
     * @return 记录主键id
     * @since JDK 1.6
     */
    DubboResult<Long> addGoodsBlackList(Long appId,Long pcgId);
    /**
     * 
     * deleteGoodsBlackList:删除一条针对商品的黑名单. <br/>
     *
     * @author xuhengfei
     * @param appId AppId
     * @param pcgId 平台券商品id
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteGoodsBlackList(Long appId,Long pcgId);
    
    /**
     * 查询app下屏蔽券列表 <br/>
     * @author zhengjy
     * @param appId AppId
     * @return PCGDto
     */
    public DubboResult<List<PCGDto>> findGoodsFilterList(Long appId);
     
    /**
     * 查询app下屏蔽分类列表 <br/>
     * @author zhengjy
     * @param appId AppId
     * @return 结果集
     */
    public DubboResult<List<PCGCategoryDto>> findCategoryFilterList(Long appId);
     
    /**
     * 查询app下屏蔽品牌列表 <br/>
     * @author zhengjy
     * @param appId AppId
     * @return 结果集
     */
    public DubboResult<List<PCGSellerDto>> findSellerFilterList(Long appId);
 
     
    /**
     * 查询券属于分类或品牌 <br/>
     * @author zhengjy
     * @param goodsId  商品id
     * @return 结果集
     */
    public DubboResult<List<PCGFilterConfigDto>> findCounponBelong(Long goodsId);
    /**
   	 * 查询优惠券，被加入品牌或类别列表 <br/>
   	 * @author zhengjy
   	 * @param appId
   	 * @return 结果集
   	 */
    public DubboResult<List<PCGCategorySellerGoodsDto>> findPCGCategorySellerGoodsList2(Long appId);
    /**
     * 查询优惠券，被加入品牌或类别id <br/>
     * @author zhengjy
     * @param appId
     * @param pageIndex 第几页
     * @param pageSize 每页多少条
     * @return id结果集
     */
    public DubboResult<List<Long>> findPCGFilterTargetIds(Long appId,Integer type);
    /**
	 已废弃
	 */
    @Deprecated
    public DubboResult<List<PCGDto>> findPCGCategorySellerGoodsList(Long appId);

}

