package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import org.apache.commons.lang.StringUtils;

/*
* 开发者，兑吧商品工具类
* @author houwen
*/
public class ItemKeyUtils {
    /**
     * 获取商品名称
     * @param itemKey
     * @return
     */
    public static String getName(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getName();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getTitle();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getTitle())) {
                return itemKey.getAppItem().getTitle();
            } else {
                return itemKey.getItem().getName();
            }
        }
        return null;
    }
    /**
     * 获取子标题
     *
     * @return
     */
    public String getSubtitle(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getSubtitle();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isBlank(itemKey.getAppItem().getSubtitle())) {
                return itemKey.getItem().getSubtitle();
            } else {
                return itemKey.getAppItem().getSubtitle();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getSubtitle();
        } else {
            return null;
        }
    }
    /**
     * 获取商品图片
     * @param itemKey
     * @return
     */
    public static String getImage(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getLogo())) {
                return itemKey.getAppItem().getImage();
            } else {
                return itemKey.getItem().getImage();
            }
        }
        return null;
    }
    /**
     * 获取缩略图
     *
     * @param itemKey
     * @return
     */
    public String getSmallImage(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getSmallImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getSmallImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getSmallImage())) {
                return itemKey.getAppItem().getSmallImage();
            } else {
                return itemKey.getItem().getSmallImage();
            }
        }
        return null;
    }
    /**
     * 获取多图
     *
     * @return
     */
    public String getMultiImage(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getMultiImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getMultiImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getMultiImage())) {
                return itemKey.getAppItem().getMultiImage();
            } else {
                return itemKey.getItem().getMultiImage();
            }
        }
        return null;
    }
    /**
     * 获取商品描述信息
     *
     * @return
     */
    public String getDescription(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getDescription();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getDescription();
        }
        return null;
    }
    /**
     * 获取价格
     *
     * @return
     */
    public Double getPrice(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().getMarketPrice() != null) {
                return itemKey.getItem().getMarketPrice() / 100.0;
            }
            return itemKey.getItem().getFacePrice() / 100.0;
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getFacePrice() / 100.0;
        }
        return null;
    }

    /**
     * 判断是否是商品中心优惠券
     * @param itemKey
     * @return
     */
    public static boolean isGoodsCoupon(ItemKeyDto itemKey) {
        if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(ItemDto.OpTypeGoodsCoupon)) {
            return true;
        }
        if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeGoodsCoupon)) {
            return true;
        }
        return false;
    }
}
