package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
 * itemKey Dto
 */
public class ItemKeyDto implements Serializable {

    private static final long serialVersionUID = 284762871342171085L;

    private AppItemDto appItem;

    private ItemDto item;


    public ItemKeyDto(AppItemDto appItem, ItemDto item) {
        this.appItem = appItem;
        this.item = item;
    }

    public ItemKeyDto(){}

    public AppItemDto getAppItem() {
        return appItem;
    }

    public ItemDto getItem() {
        return item;
    }

    public String getItemType() {
        return this.getItem() != null ? this.getItem().getType() : (
                this.getAppItem() != null ? this.getAppItem().getType() : null);
    }

    public boolean isValid() {
        return this.getItem() != null || this.getAppItem() != null;
    }

    public boolean isItemMode() {
        return this.item != null && this.appItem == null;
    }

    public boolean isSelfAppItemMode() {
        return this.item == null && this.appItem != null;
    }

    public boolean isDuibaAppItemMode() {
        return this.item != null && this.appItem != null;
    }

    public void setAppItem(AppItemDto appItem) {
        this.appItem = appItem;
    }

    public void setItem(ItemDto item) {
        this.item = item;
    }

    public Boolean isAmbItemKey() {
        return this.isDuibaAppItemMode() ? Boolean.valueOf(false) : (this.isSelfAppItemMode() ? Boolean.valueOf(
                this.appItem.isOpTypeAppItem(11)) : Boolean.valueOf(this.item.isOpTypeItem(11)));
    }

    public boolean isAutoOff() {
        boolean itemAutoOff = false;
        Date today = new Date();
        if (this.getItem() != null && this.getItem().getAutoOffDate() != null) {
            itemAutoOff = this.getItem().getAutoOffDate().before(today);
        }

        boolean appItemAutoOff = false;
        if (this.getAppItem() != null && this.getAppItem().getAutoOffDate() != null) {
            appItemAutoOff = this.getAppItem().getAutoOffDate().before(today);
        }

        return itemAutoOff && appItemAutoOff;
    }
}
