package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ItemMarkEnum;

import org.apache.commons.lang.StringUtils;

/*
* 开发者，兑吧商品工具类
* @author houwen
*/
public class ItemKeyUtils {
    /**
     * 获取有效的Id
     * @return
     */
    public static Long getId(ItemKeyDto itemKey){
        if(itemKey.getAppItem()!=null){
            if(itemKey.getAppItem().getId()==null){
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getId();
                }
                return null;
            }else{
                return itemKey.getAppItem().getId();
            }
        }else{
            return itemKey.getItem().getId();
        }
    }

    /**
     * 获取商品类型
     * @return
     */
    public static String getType(ItemKeyDto itemKey){
        if(itemKey.getAppItem()!=null){
            if(itemKey.getAppItem().getType()==null){
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getType();
                }
                return null;
            }else{
                return itemKey.getAppItem().getType();
            }
        }else{
            return itemKey.getItem().getType();
        }
    }


    /**
     * 获取商品名称
     * @param itemKey
     * @return
     */
    public static String getName(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getName();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getTitle();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getTitle())) {
                return itemKey.getAppItem().getTitle();
            } else {
                return itemKey.getItem().getName();
            }
        }
        return null;
    }
    /**
     * 获取子标题
     *
     * @return
     */
    public static String getSubtitle(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getSubtitle();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isBlank(itemKey.getAppItem().getSubtitle())) {
                return itemKey.getItem().getSubtitle();
            } else {
                return itemKey.getAppItem().getSubtitle();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getSubtitle();
        } else {
            return null;
        }
    }

    public static String getTitle(ItemKeyDto itemKey){
        if(itemKey.getAppItem()!=null){
            if(itemKey.getAppItem().getTitle()==null){
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getName();
                }
                return null;
            }else{
                return itemKey.getAppItem().getTitle();
            }
        }else{
            return itemKey.getItem().getName();
        }
    }

    /**
     * 获取商品图片
     * @param itemKey
     * @return
     */
    public static String getImage(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getLogo())) {
                return itemKey.getAppItem().getImage();
            } else {
                return itemKey.getItem().getImage();
            }
        }
        return null;
    }

    public static String getLogo(ItemKeyDto itemKey){
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getLogo();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getLogo();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getLogo())) {
                return itemKey.getAppItem().getLogo();
            } else {
                return itemKey.getItem().getLogo();
            }
        }
        return null;
    }

    /**
     * 按图片风格获取缩略图
     *
     * @param itemKey
     * @return
     */
    public static String getThumbnailImage(ItemKeyDto itemKey,Integer imageStyle) {
        return getThumbnailImage(itemKey.getAppItem(),itemKey.getItem(),imageStyle);
    }

    public static String getThumbnailImage(AppItemDto appItem, ItemDto item, Integer imageStyle) {
        String smallImage = "";
        String whiteImage = "";
        if(item!=null && appItem==null){//兑吧模式
            smallImage = item.getSmallImage();
            whiteImage = item.getWhiteImage();
        }
        if(item!=null && appItem!=null){
            smallImage = StringUtils.isNotBlank(appItem.getSmallImage())?appItem.getSmallImage():item.getSmallImage();
            whiteImage = StringUtils.isNotBlank(appItem.getWhiteImage())?appItem.getWhiteImage():item.getWhiteImage();
        }
        if(item==null && appItem!=null){
            smallImage = appItem.getSmallImage();
            whiteImage = appItem.getWhiteImage();
        }
        return getThumbnailImage(smallImage, whiteImage, imageStyle);
    }

    public static String getThumbnailImage(String smallImage, String whiteImage,Integer imageStyle) {
        String image = "";
        if(imageStyle==0){
            image = StringUtils.isNotBlank(smallImage)?smallImage:whiteImage;
        }
        if(imageStyle==1){
            image = StringUtils.isNotBlank(whiteImage)?whiteImage:smallImage;
        }
        return StringUtils.isNotBlank(image)?image:"//yun.duiba.com.cn/developer/img/default_img.jpg";
    }

    /**
     * 获取商品描述信息
     *
     * @return
     */
    public static String getDescription(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getDescription();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getDescription();
        }
        return null;
    }
    /**
     * 获取价格
     *
     * @return
     */
    public static Double getPrice(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().getMarketPrice() != null) {
                return itemKey.getItem().getMarketPrice() / 100.0;
            }
            return itemKey.getItem().getFacePrice() / 100.0;
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getFacePrice() / 100.0;
        }
        return null;
    }

    public static Long getSalePrice(ItemKeyDto itemKey){
        if (itemKey.isItemMode() && null != itemKey.getItem().getSalePrice()) {
            return itemKey.getItem().getSalePrice();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if(null != itemKey.getAppItem().getSalePrice()) {
                return itemKey.getAppItem().getSalePrice();
            } else if(null != itemKey.getItem().getSalePrice()) {
                return itemKey.getItem().getSalePrice();
            }
        }
        if (itemKey.isSelfAppItemMode() && null != itemKey.getAppItem().getSalePrice()) {
            return itemKey.getAppItem().getSalePrice();
        }
        return null;
    }

    /**
     * 判断是否是商品中心优惠券
     * @param itemKey
     * @return
     */
    public static boolean isGoodsCoupon(ItemKeyDto itemKey) {
        if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(ItemDto.OpTypeGoodsCoupon)) {
            return true;
        }
        if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeGoodsCoupon)) {
            return true;
        }
        return false;
    }
    
    /**
     * 获取商品角标
     * @param itemKey
     * @return
     */
    public static ItemMarkEnum getMarkType(ItemKeyDto itemKey){
    	if (itemKey.isDuibaAppItemMode()) {
            // 秒杀（限时）
            if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeTimeLimit) || itemKey.getItem().isOpTypeItem(ItemDto.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            } else if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeAddrLimit) || itemKey.getItem().isOpTypeItem(ItemDto.OpTypeAddrLimit)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isItemMode()) {
            // 秒杀（限时）
            if (itemKey.getItem().isOpTypeItem(ItemDto.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            }else if (itemKey.getItem().isOpTypeItem(ItemDto.OpTypeAddrLimit)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeAddrLimit)) {
                //地域限制
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }else if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeTimeLimit)) {
                // 秒杀（限时）
                return ItemMarkEnum.MARK_TIME;
            }else if (itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeSingleLottery
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeOperatingActivity
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeManualLottery
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeAppShakeLottery
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTiger
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTurntable
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameSanta
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameYearAward
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameGirl
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameJiong
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuestionAnswer
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuizz
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeNgame
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGuess) {
                // 抽奖
                return ItemMarkEnum.MARK_LOTTERY;
            }
        }
        return ItemMarkEnum.MARK_NORMAL;
    }
}
