/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年6月14日上午11:50:19
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGoodsBackendService <br/>
 * Function: 商品中心查询接口 <br/>
 * Date:     2016年6月14日 上午11:50:19 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsBackendService {
    /**
     * 查询商品的库存信息
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @return
     * @since JDK 1.6
     */
    public DubboResult<GoodsStockDto> findGoodsStock(GoodsTypeEnum gtype,long gid);
}

