package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
 * itemKey Dto
 */
public class ItemKeyDto implements Serializable {

	private static final long serialVersionUID = 284762871342171085L;

	private AppItemDto appItemDto;

	private ItemDto itemDto;

	private Long appId;

	public ItemKeyDto(AppItemDto appItemDto, ItemDto itemDto, Long appId) {
		this.appItemDto = appItemDto;
		this.itemDto = itemDto;
		this.appId = appId;
	}

	public ItemKeyDto() {
	}

	public Long getAppId() {
		return appId;
	}

	public AppItemDto getAppItemDto() {
		return appItemDto;
	}

	public ItemDto getItemDto() {
		return itemDto;
	}

	public String getItemDtoType() {
		return this.getItemDto() != null ? this.getItemDto().getType() : (this.getAppItemDto() != null ? this.getAppItemDto().getType() : null);
	}

	public boolean isValid() {
		return this.getItemDto() != null || this.getAppItemDto() != null;
	}

	public boolean isItemMode() {
		return this.getItemDto() != null && this.getAppItemDto() == null;
	}

	public boolean isSelfAppItemMode() {
		return this.getItemDto() == null && this.getAppItemDto() != null;
	}

	public boolean isDuibaAppItemMode() {
		return this.getItemDto() != null && this.getAppItemDto() != null;
	}

	public Boolean isAmbItemKey() {
		return this.isDuibaAppItemMode() ? Boolean.valueOf(false) : (this.isSelfAppItemMode() ? Boolean.valueOf(this.getAppItemDto().isOpTypeAppItem(ItemDto.OpTypeIsAmb)) : Boolean.valueOf(this.getItemDto().isOpTypeItem(ItemDto.OpTypeIsAmb)));
	}

	public boolean isAutoOff() {
		boolean itemAutoOff = false;
		Date today = new Date();
		if (this.getItemDto() != null && this.getItemDto().getAutoOffDate() != null) {
			itemAutoOff = this.getItemDto().getAutoOffDate().before(today);
		}

		boolean appItemAutoOff = false;
		if (this.getAppItemDto() != null && this.getAppItemDto().getAutoOffDate() != null) {
			appItemAutoOff = this.getAppItemDto().getAutoOffDate().before(today);
		}

		return itemAutoOff && appItemAutoOff;
	}
}
