package cn.com.duiba.goods.center.api.remoteservice.itemGoods;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 兑吧商品相关服务
 * 
 * @author houwen
 */
public interface RemoteDuibaItemGoodsService {

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<ItemDto> find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public DubboResult<List<ItemDto>> findByIds(List<Long> ids);

	/**
	 * 创建商品
	 * 
	 * @param appItemDto
	 * @return
	 */
	public DubboResult<Long> insert(ItemDto itemDto);

	/**
	 * 修改商品
	 * 
	 * @param appItem
	 * @return
	 */
	public DubboResult<Boolean> update(ItemDto itemDto);

	/**
	 * 删除商品
	 * 
	 * @param itemId
	 */
	public DubboResult<Boolean> delete(Long itemId);

	/**
	 * 修改启用禁用
	 * 
	 * @param itemId
	 * @param enable
	 * @return
	 */
	public DubboResult<Boolean> updateEnable(Long itemId, Boolean enable);

	/**
	 * 编辑商品，增加库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> appendStock(Long itemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> deductStock(Long itemId, Long number);

	/**
	 * 查询兑吧自动推荐商品
	 * 
	 * @param appId
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAutoRecommend(Long appId);

}
