package cn.com.duiba.goods.center.api.remoteservice.itemGoods;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 商品封装服务
 * 
 * @author houwen
 */
public interface RemoteItemKeyService {

	/**
	 * 查询商品封装信息
	 * 
	 * @param appItemId 开发者商品ID
	 * @param itemId 兑吧商品ID
	 * @param appId 应用ID
	 * @return
	 */
	public DubboResult<ItemKeyDto> findItemKey(Long appItemId, Long itemId, Long appId);

	/**
	 * 查询当前库存
	 * 
	 * @param itemKeyDto
	 *            商品对象
	 * @return
	 */
	public DubboResult<Long> findStock(ItemKeyDto itemKeyDto);

	/**
	 * 消耗商品库存
	 * 
	 * @param itemKeyDto 商品对象
	 * @return
	 */
	public DubboResult<Boolean> consumeStock(ItemKeyDto itemKeyDto, String bizId, String bizSource);

	/**
	 * 返还商品库存
	 * 
	 * @param itemKeyDto 商品对象
	 * @param bizId 业务流水号
	 * @param bizSource 业务类型
	 * @return
	 */
	public DubboResult<Boolean> rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource);

}
