package cn.com.duiba.goods.center.api.remoteservice.tool;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;

/**
 * 开发者，兑吧商品工具类
 * 
 * @author houwen
 */
public class ItemKeyUtils {
	
	/**
	 * 是否是商品中心优惠券
	 * @param itemKeyDto
	 * @return
	 */
	public static boolean isGoodsCoupon(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().isOpTypeAppItem(ItemDto.OpTypeGoodsCoupon);
		}
		if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
			return itemKeyDto.getItemDto().isOpTypeItem(ItemDto.OpTypeGoodsCoupon);
		}
		return false;
	}

	/**
	 * 获取商品名称
	 * 
	 * @param GoodsItemDto
	 * @return
	 */
	public static String getName(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isItemMode()) {
			return itemKeyDto.getItemDto().getName();
		}
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().getTitle();
		}
		if (itemKeyDto.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKeyDto.getAppItemDto().getTitle())) {
				return itemKeyDto.getAppItemDto().getTitle();
			} else {
				return itemKeyDto.getItemDto().getName();
			}
		}
		return null;
	}

	/**
	 * 获取子标题
	 * 
	 * @return
	 */
	public String getSubtitle(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isItemMode()) {
			return itemKeyDto.getItemDto().getSubtitle();
		} else if (itemKeyDto.isDuibaAppItemMode()) {
			if (StringUtils.isBlank(itemKeyDto.getAppItemDto().getSubtitle())) {
				return itemKeyDto.getItemDto().getSubtitle();
			} else {
				return itemKeyDto.getAppItemDto().getSubtitle();
			}
		} else if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().getSubtitle();
		} else {
			return null;
		}
	}

	/**
	 * 获取商品图片
	 * 
	 * @param GoodsItemDto
	 * @return
	 */
	public static String getImage(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isItemMode()) {
			return itemKeyDto.getItemDto().getImage();
		}
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().getImage();
		}
		if (itemKeyDto.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKeyDto.getAppItemDto().getLogo())) {
				return itemKeyDto.getAppItemDto().getImage();
			} else {
				return itemKeyDto.getItemDto().getImage();
			}
		}
		return null;
	}

	/**
	 * 获取缩略图
	 * 
	 * @param GoodsItemDto
	 * @return
	 */
	public String getSmallImage(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isItemMode()) {
			return itemKeyDto.getItemDto().getSmallImage();
		}
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().getSmallImage();
		}
		if (itemKeyDto.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKeyDto.getAppItemDto().getSmallImage())) {
				return itemKeyDto.getAppItemDto().getSmallImage();
			} else {
				return itemKeyDto.getItemDto().getSmallImage();
			}
		}
		return null;
	}

	/**
	 * 获取多图
	 * 
	 * @return
	 */
	public String getMultiImage(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isItemMode()) {
			return itemKeyDto.getItemDto().getMultiImage();
		}
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().getMultiImage();
		}
		if (itemKeyDto.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKeyDto.getAppItemDto().getMultiImage())) {
				return itemKeyDto.getAppItemDto().getMultiImage();
			} else {
				return itemKeyDto.getItemDto().getMultiImage();
			}
		}
		return null;
	}

	/**
	 * 获取商品描述信息
	 * 
	 * @return
	 */
	public String getDescription(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
			return itemKeyDto.getItemDto().getDescription();
		}
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().getDescription();
		}
		return null;
	}

	/**
	 * 获取价格
	 * 
	 * @return
	 */
	public Double getPrice(ItemKeyDto itemKeyDto) {
		if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
			if (itemKeyDto.getItemDto().getMarketPrice() != null) {
				return itemKeyDto.getItemDto().getMarketPrice() / 100.0;
			}
			return itemKeyDto.getItemDto().getFacePrice() / 100.0;
		}
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItemDto().getFacePrice() / 100.0;
		}
		return null;
	}

}
