package cn.com.duiba.goods.center.api.remoteservice.item;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 开发者商品相关服务
 * 
 * @author houwen
 */
public interface RemoteAppItemGoodsService {

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<AppItemDto> find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByIds(List<Long> ids);

	/**
	 * 创建商品
	 * 
	 * @param appItemDto
	 * @return
	 */
	public DubboResult<Long> insert(AppItemDto appItemDto);

	/**
	 * 修改商品
	 * 
	 * @param appItemDto
	 * @return
	 */	
	public DubboResult<Boolean> update(AppItemDto appItemDto);

	/**
	 * 删除商品
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public DubboResult<Boolean> delete(Long appId, Long appItemId);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemIds
	 * @return
	 */
	public DubboResult<Integer> deleteByIds(Long appId, List<Long> appItemIds);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Boolean> updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Integer> updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 编辑商品，增加库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> appendStock(Long appId, Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> deductStock(Long appId, Long appItemId, Long number);

}
