/**
 * Project Name:goods-center-api
 * File Name:RemotePCGConsumerService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月30日下午5:43:43
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import java.util.List;
import java.util.Map;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGConsumerService <br/>
 * Function: 用户相关的服务. <br/>
 * Date:     2016年6月30日 下午5:43:43 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsConsumerService {
	
    /**
     * @Deprecated
     * 应该返回DubboResult类型，目前已经废弃
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param consumerId 用户id
     * @return 用户兑换次数
     * @since JDK 1.6
     */
	Integer findConsumerExchangeCount(int gtype,long gid,long consumerId);
    /**
     * 用户对一个商品的兑换次数<br/>
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param consumerId 用户id
     * @return 用户兑换次数
     * @since JDK 1.6
     */
    DubboResult<Integer> findConsumerExchangeCount2(int gtype,long gid,long consumerId);
    
    /**
     * 用户对多个商品的兑换次数<br/>
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gids 商品id串
     * @param consumerId 用户id
     * @return 批量用户兑换次数的Map返回
     * @since JDK 1.6
     */
    DubboResult<Map<Long,Integer>> findConsumerExchangeCounts(int gtype,List<Long> gids,long consumerId);
    
}

