package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 增加兑换记录接口
 * Created by gyf .
 * 16/10/19 .
 */
public interface RemoteGoodsLimitRecordService {

    /**
     * 查询已经兑换的次数
     * @param gtype
     * @param gid
     * @param consumerId
     * @return
     */
    DubboResult<Integer> findCount(int gtype, long gid, long consumerId);

    /**
     * 插入一条兑换记录
     * @param gtype
     * @param gid
     * @param consumerId
     * @return
     */
    DubboResult<Void> addRecord(int gtype, long gid, long consumerId);

    /**
     * 回滚一个兑换记录
     * @param gtype
     * @param gid
     * @param consumerId
     * @return
     */
    DubboResult<Void> rollbackRecord(int gtype, long gid, long consumerId);
}
