/**
 * Project Name:goods-center-api
 * File RemoteGoodsBatchService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月30日下午5:43:43
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
 */

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodCouponRetrieveLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * ClassName:RemoteGoodsBatchService <br/>
 * Function: 商品批次服务. <br/>
 * Date: 2016年8月01日 下午5:43:43 <br/>
 * 
 * @author zhengjy
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteGoodsBatchService {

	/**
	 * 查询多个商品批次<br/>
	 *
	 * @author xuhengfei
	 * @param gtype
	 *            商品类型
	 * @param gids
	 *            商品id
	 * @return 结果Map对象
	 * @since JDK 1.6
	 */
	DubboResult<Map<Long, List<GoodsBatchDto>>> findGoodsBatchs(GoodsTypeEnum gtype, List<Long> gids);

	/**
	 * 查询多个商品批次<br/>
	 *
	 * @author xuhengfei
	 * @param gtype
	 *            商品类型
	 * @param gid
	 *            商品id
	 * @return 结果集
	 * @since JDK 1.6
	 */
	DubboResult<List<GoodsBatchDto>> findGoodsBatch(GoodsTypeEnum gtype, Long gid);

	/**
	 * 回收某个优惠券某个批次的券码
	 * @param gtype
	 * @param gid
	 * @param batchId
	 * @param dstQuantity
	 * @return
	 */
	DubboResult<Long> retrieveGoodsBatch(GoodsTypeEnum gtype, Long gid, Long batchId, Long dstQuantity);

	/**
	 * 查询回收结果
	 * 
	 * @param id
	 * @return
	 */
	DubboResult<GoodCouponRetrieveLogDto> queryRetrieveRet(Long id);

}
