/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsCouponService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年5月24日下午4:19:45
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGoodsCouponService <br/>
 * Function: 前台服务，提供发券和还券操作 <br/>
 * Date:     2016年5月24日 下午4:19:45 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsCouponService {
    /**
     * 
     * @deprecated
     * 领一张券
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param consumerId 用户id
     * @param bizNum 业务编号
     * @return 券信息
     * @since JDK 1.6
     */
	@Deprecated
    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype,long gid,long consumerId,String bizNum);
    /**
     * 确认完成一张券(在订单最终成功时来调用此方法)
     *
     * @author xuhengfei
     * @param couponId 券号
     * @param orderId 订单id
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> completeCoupon(Long couponId,long orderId);
    /**
     * 回滚一张券<br/>
     * 如果先锁定一张券，最终订单失败了，需要调用此方法，将券回滚为 未使用  状态
     *
     * @author xuhengfei
     * @param couponId 券号
     * @param bizNum 业务编号
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> rollbackCoupon(Long couponId,String bizNum);
    /**
     * 根据券码ID查询券码DTO
     * @author houwen
     * @param gtype GTYPE
     * @param gid GID
     * @param couponId 券码ID
     * @return
     */
    public DubboResult<GoodsCouponDto> findCoupon(GoodsTypeEnum gtype,long gid, Long couponId);
    
    /**
     * 查询当前使用中的批次信息（前台用户展示过期开始结束时间）
     * @param gtype
     * @param gid
     * @return
     */
    public DubboResult<GoodsBatchDto> findUsingBatch(GoodsTypeEnum gtype,long gid);
    
    /**
     * 查询商品当前批次库存
     * @author houwen
     * @param gtype
     * @param gid
     * @return
     */
    public DubboResult<Long> findGoodsStock(GoodsTypeEnum gtype,long gid);
    
    /**
     * 批量查询商品当前批次库存
     * @author houwen
     * @param goods
     * @return
     */
    public DubboResult<List<GoodsStockDto>> findGoodsStockByBatch(List<GoodsStockDto> goods);
    /**
     * @deprecated
     * 查询一张券信息
     *
     * @author xuhengfei
     * @param couponId 券号
     * @return 券信息
     * @since JDK 1.6
     */
    @Deprecated
    public GoodsCouponDto findCoupon(long couponId);
    
    /**
	 * 领一张券
	 * 
	 * @param gtype 商品类型
	 * @param gid 商品id
	 * @param consumerId 用户id
	 * @param appId 应用ID
	 * @param bizNum 业务编号
	 * @return
	 */
	public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype, long gid, Long consumerId, Long appId, String bizNum);

}

