package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.PreStockDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2017/1/11.
 * 预分配库存服务
 * 原有的 remotePreStockPointService 和 remotePreStockService 提供的查询业务性太弱 会导致dubbo多次调用
 * 这里将PreStockDO中的stock统一整合到PreStockPoint中, 同时变更为 PreStockDto
 */
public interface RemotePreStockService {

    /**
     * 获取兑吧商品对App的定向库存
     * 如果兑吧商品没有对该应用设置私有库存,则返回共享库
     * 如果兑吧商品没有设置库存预分配,则忽略itemId
     * @param itemIds
     * @param appId
     * @return
     */
    DubboResult<List<PreStockDto>> findAllPreStock(List<Long> itemIds,Long appId);

}
