/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsDirectionalConfigBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年6月28日上午10:45:30
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGoodsDirectionalConfigBackendService <br/>
 * Date:     2016年6月28日 上午10:45:30 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteGoodsDirectionalConfigBackendService {
    /**
     * find:根据id查找. <br/>
     * @author wubo
     * @param id 定向配置的主键id
     * @return 定向配置信息
     * @since JDK 1.6
     */
    public DubboResult<GoodsDirectionalConfigDto> find(Long id);
    /**
     * findByGoods:查询某商品的定向配置. <br/>
     *
     * @author wubo
     * @param gtype 商品类型
     * @param goodsId 商品id
     * @return 结果集
     * @since JDK 1.6
     */
    public DubboResult<List<GoodsDirectionalConfigDto>> findByGoods(GoodsTypeEnum gtype,Long goodsId);
    /**
     * 
     * add:批量添加定向配置. <br/>
     * 必填字段：goodsId,gtype,appId,stockChange.<br/>
     * 可填：dayLimit,minPrice.<br/>
     *
     * @author wubo
     * @param list 需要添加的配置列表
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> add(List<GoodsDirectionalConfigDto> list);
    /**
     * 
     * delete:删除. <br/>
     * @author wubo
     * @param id 主键id
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> delete(Long id);
    /**
     * 
     * update:批量更新. <br/>
     * 必填字段：id.<br/>
     * 可修改字段：dayLimit,minPrice,stockChange.<br/>
     *
     * @author wubo
     * @param list 需要批量更新的列表
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> update(List<GoodsDirectionalConfigDto> list);
    
    /**
     * 
     * isExist:查询某商品定向app列表中是否存在某app. <br/>
     * 共享库  app_id 为0 <br/>
     * @author wubo
     * @param gtype 商品类型
     * @param goodsId 商品id
     * @param appId App的Id
     * @return 是否存在
     * @since JDK 1.6
     */
    public DubboResult<Boolean> isExist(GoodsTypeEnum gtype,Long goodsId,Long appId);
    
    /**
     * 
     * findByGoodsAndApp:根据商品与app查询. <br/>
     *
     * @author wubo
     * @param gtype 商品类型
     * @param goodsId 商品id
     * @param appId App的Id
     * @return 定向配置信息
     * @since JDK 1.6
     */
    public DubboResult<GoodsDirectionalConfigDto> findByGoodsAndApp(GoodsTypeEnum gtype,Long goodsId,Long appId);
    

}

