/**
 * Project Name:goods-center-api
 * File Name:RemotePCGGoodsService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月27日下午5:57:03
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGGoodsService <br/>
 * Function: 平台券前台服务 <br/>
 * Date:     2016年6月27日 下午5:57:03 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemotePCGGoodsService {
    /**
     * 
     * 检查平台券商品是否有库存 <br/>
     * 总库存，预分配库存，每日限量库存
     * @author xuhengfei
     * @param pcgId 商品id
     * @param appId AppId
     * @param consumerId 用户id
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> checkStockEnough(long pcgId,long appId,long consumerId);
    /**
     * 
     * 查询平台券商品的积分消耗值 <br/>
     * 定向设置积分，正常换算积分
     * @author xuhengfei
     * @param pcgId 商品id
     * @param appId AppId
     * @param consumerId 用户id
     * @return 积分值
     * @since JDK 1.6
     */
    DubboResult<Long> calcultePCGCredits(long pcgId,long appId,long consumerId,long calcultePCGCredits);
    /**
     * 是否可以兑换此商品
     * 此处会计算用户兑换限制，库存，定向等等信息
     * @author xuhengfei
     * @param pcgId 商品id
     * @param appId AppId
     * @param consumerId 用户id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> canTakePlatformCouponGoods(long pcgId,long appId,long consumerId);
    /**
     * 
     * 下单一张平台券 <br/>
     * @author xuhengfei
     * @param pcgId 平台券商品id
     * @param appId AppId
     * @param consumerId 用户id
     * @param orderNum 订单号
     * @return 平台券couponId
     * @since JDK 1.6
     */
    DubboResult<Long> takePlatformCouponGoods(long pcgId,long appId,long consumerId,String orderNum);
    /**
     * 回滚一个平台优惠劵
     * @param pcgId
     * @param couponId
     * @param orderNum
     * @param appId
     * @return
     */
	DubboResult<Void> rollbackPCGCoupon(long pcgId, long consumerId, long couponId, String orderNum, Long appId);
    
}

