package cn.com.duiba.goods.center.api.remoteservice.item;

import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 开发者商品后台接口
 */
public interface RemoteAppItemGoodsBackendService {

	/**
	 * 修改状态
	 * 
	 * @return
	 */
	public DubboResult<Integer> updateStatusByActivityId(String status, Boolean deleted, Long activityId, int type);

	/**
	 * 根据兑吧商品ID查询开发者商品个数
	 * 
	 * @param itemId
	 * @return
	 */
	public DubboResult<Integer> findCountByItemId(Long itemId);

	/**
	 * 根据兑吧商品ID查询开发者上架和的商品
	 * 
	 * @param itemId
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findOnShelfByItemId(Long itemId);

	/**
	 * 上架或者下架
	 */
	public DubboResult<Integer> standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay);

	/**
	 * 更新活动工具兑换项入口
	 * 
	 * @param id
	 * @param title
	 * @param smallImage
	 * @param whiteImage
	 * @param credits
	 * @param customPrice
	 * @param logo
	 * @param operationsType
	 * @return
	 */
	public DubboResult<Integer> updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType);

	/**
	 * 更新专题活动主推兑换项属性
	 * 
	 * @param id
	 * @param title
	 * @param logo
	 * @param smallImage
	 * @param whiteImage
	 * @param bannerImage
	 * @param credits
	 * @param subtitle
	 * @return
	 */
	public DubboResult<Integer> updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle);

	/**
	 * findAllBySourceTypeAndRelationIdAndDeleted
	 * 
	 * @param sourceType
	 * @param itemId
	 * @param deleted
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findAllBySourceTypeAndRelationIdAndDeleted(int sourceType, long sourceRelationId, Boolean deleted);

	/**
	 * publishItem分页查询
	 * 
	 * @param queryPublish
	 * @return
	 */
	public DubboResult<Page<AppItemDto>> findPublishItemLimit(Map<String, Object> queryPublish);

	/**
	 * 分页查询
	 * 
	 * @param params
	 * @return
	 */
	public DubboResult<Page<AppItemDto>> findByLimit(Map<String, Object> params);
	
	/**
     * 获取app下所有上架的可用的自有商品(优惠券,实物,虚拟物品)
     * 
     * @param appId
     * @return
     */
    public DubboResult<List<Long>> findSelfAppItemIdsByAppId(Long appId);

}
