package cn.com.duiba.goods.center.api.remoteservice.item;

import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 开发者商品相关服务
 * 
 * @author houwen
 */
public interface RemoteAppItemGoodsService {

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<AppItemDto> find(Long id);
	
	/**
	 * 根据APPid和兑吧商品ID查询开发者商品
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public DubboResult<AppItemDto> findByAppAndItem(Long appId, Long itemId);

	/**
	 * 根据APPid和兑吧商品IDs查询开发者商品
	 * @param appId
	 * @param itemIds
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByAppAndItems(Long appId, List<Long> itemIds);

	/**
	 * 根据APPid和兑吧商品ID查询开发者商品上架的
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public DubboResult<AppItemDto> findByAppAndItemOnline(Long appId, Long itemId);
	
	/**
	 * 获取banner对应商品项(缓存,缺省字段)
	 * 
	 * @param appId
	 * @param appItems
	 * @return
	 */
    public DubboResult<List<AppItemDto>> findBannerIconAppItemByCache(Long appId,List<Long> appItems);

	/**
	 * 根据ID集合查询应用商品信息
	 *
	 * @param ids
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByIds(List<Long> ids);
	
	/**
	 * 根据RelationId批量查询AppItemId
	 * @return
	 */
	public DubboResult<List<Long>> findIDbySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes);

	public DubboResult<List<AppItemDto>> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId);

	/**
	 * 手机端分页查询商品
	 * @param params
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByLimitCache(Long appId, Map<String, Object> queryParams);
	
	/**
	 * 查询APP商品最大的排序
	 * @param appId
	 * @return
	 */
	public DubboResult<Integer> findAppMaxPayload(Long appId);
	
	/**
	 * 创建商品
	 * 
	 * @param appItemDto
	 * @return
	 */
	public DubboResult<Long> insert(AppItemDto appItemDto);

	/**
	 * 修改商品
	 * 
	 * @param appItemDto
	 * @return
	 */	
	public DubboResult<Boolean> update(AppItemDto appItemDto);

	/**
	 * 删除商品
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public DubboResult<Boolean> delete(Long appId, Long appItemId);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemIds
	 * @return
	 */
	public DubboResult<Integer> deleteByIds(Long appId, List<Long> appItemIds);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Boolean> updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Integer> updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 编辑商品，增加库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> appendStock(Long appId, Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> deductStock(Long appId, Long appItemId, Long number);

	/**
	 * 根据releationID批量修改状态
	 * @param status
	 * @param delete
	 * @param oids
	 * @return
	 */
    public DubboResult<Integer> updateStatusByActivityIds(String status, Boolean delete, List<Long> oids);

	/**
	 * 根据活动ID更新状态
	 */
	public DubboResult<Integer> updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type);

}
