/**
 * Project Name:goods-center-api
 * File Name:RemotePCGConsumerService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月30日下午5:43:43
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Function: 商品每日限量相关服务. <br/>
 * @author   houwen
 * @version  
 * @see 	 
 */
public interface RemoteEverydayLimitService {
	
	/**
	 * @deprecated
	 * 查询每日限量的销售数量
	 * @param appItemId
	 * @param itemId
	 * @return
	 */
	@Deprecated
	public DubboResult<Integer> findEverydayLimitSales(Long appItemId, Long itemId);
	
	/**
	 * @deprecated
	 * 每日限量验证
	 * @param appItemId
	 * @param itemId
	 * @param limit
	 * @return
	 */
	@Deprecated
	public DubboResult<Boolean> everydayLimitCheck(Long appItemId, Long itemId, int limit);
	
	/**
	 * 返还每日限量库存
	 * @param appItemId
	 * @param itemId
	 * @return
	 */
	public DubboResult<Void> rollbackEverydayLimit(Long appItemId, Long itemId);
	
	/**
	 * 查询每日限量库存
	 * 
	 * @param itemKeyDto
	 * @return 库存
	 */
	public DubboResult<Long> findEverydayLimitStock(ItemKeyDto itemKeyDto);

	/**
	 * 扣每日限量库存
	 * @param itemKeyDto
	 * @return
	 */
	public DubboResult<Boolean> decrEverydayLimitStock(ItemKeyDto itemKeyDto);
    
}

