package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

import static cn.com.duiba.goods.center.api.remoteservice.enums.UploadImageEnum.BANNER_IMAGE_NEW;
import static cn.com.duiba.goods.center.api.remoteservice.enums.UploadImageEnum.SMALL_IMAGE_NEW;

/**
 * item 扩展表
 */
public class ItemExtraDto implements Serializable {
    private static final long serialVersionUID = -26122562121559924L;

    private Long   id;
    private Long   itemId;
    private String name4Admin;
    private Date   gmtCreate;
    private Date   gmtModified;
    private String usePrompt;
    private String btnText;

    //json图片字符串
    private String imageJson;

    //新版首页banner
    private String bannerImgNew;
    //新版缩略图
    private String smallImgNew;

    private Map<String, String> imageJsonMap = Maps.newHashMap();
    
    public String getUsePrompt() {
        return usePrompt;
    }

    public void setUsePrompt(String usePrompt) {
        this.usePrompt = usePrompt;
    }

    public String getBtnText() {
        return btnText;
    }

    public void setBtnText(String btnText) {
        this.btnText = btnText;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getName4Admin() {
        return name4Admin;
    }

    public void setName4Admin(String name4Admin) {
        this.name4Admin = name4Admin;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getImageJson() {
        return imageJson;
    }

    public void setImageJson(String imageJson) {
        this.imageJson = imageJson;
    }

    public String getImageJsonMap() {
        return JSON.toJSONString(imageJsonMap);
    }

    public void setImageJsonMap(Map<String, String> imageJsonMap) {
        this.imageJsonMap = imageJsonMap;
    }

    public String getBannerImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(BANNER_IMAGE_NEW.getCode());
        }

        return StringUtils.EMPTY;
    }

    public void setBannerImgNew(String bannerImgNew) {
        imageJsonMap.put(BANNER_IMAGE_NEW.getCode(), bannerImgNew);
    }

    public String getSmallImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(SMALL_IMAGE_NEW.getCode());
        }

        return StringUtils.EMPTY;
    }

    public void setSmallImgNew(String smallImgNew) {
        imageJsonMap.put(SMALL_IMAGE_NEW.getCode(), smallImgNew);
    }

}
