package cn.com.duiba.goods.center.api.remoteservice.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 兑换项优惠券商品后台接口
 */
public interface RemoteItemCouponGoodsBackendService {
	
	/**
	 * 批量优惠券码分页
	 * @param param
	 * @return
	 */
	DubboResult<List<GoodsCouponDto>> findPageByBatchIdAndStatus(GoodsCouponQueryParamDto param);
	
	/**
	 * 导入普通券码
	 * @param itemKeyDto
	 * @param batchId
	 * @param startDay
	 * @param endDay
	 * @param fileUrl
	 * @return
	 */
	public DubboResult<Long> importCouponNormal(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String fileUrl);
	
	/**
	 * 导入链接券码
	 * @param itemKeyDto
	 * @param batchId
	 * @param startDay
	 * @param endDay
	 * @param link
	 * @param stock
	 * @return
	 */
	public DubboResult<Boolean> importCouponLink(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String link, Long stock);
	
	/**
	 * 导入重复券码
	 * @param itemKeyDto
	 * @param batchId
	 * @param startDay
	 * @param endDay
	 * @param code
	 * @param password
	 * @param stock
	 * @return
	 */
	public DubboResult<Boolean> importCouponRepeat(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String code, String password, Long stock);

}
