package cn.com.duiba.goods.center.api.remoteservice.util;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;

/**
 * 角标工具类，
 * moved from duiba-service by xiaoxuda on 2016/11/16.
 */
public class ItemCornerTagUtils {
	
	private static final String CUSTOMTAGSPLITSYMBOL = ",";
	private static Joiner joiner = Joiner.on(CUSTOMTAGSPLITSYMBOL).skipNulls();
	//将CustomTag分割后，每部分的意义
	public static final int CUSTOMTAG_NO1 = 0;//自定义角标文案
	public static final int CUSTOMTAG_NO2 = 1;//自定义角标颜色
	
	private ItemCornerTagUtils() {
	}
	
	/**
	 * 得到自有兑换项自定义角标的文案
	 * 不会返回null
	 * @param appItem
	 * @return
	 */
	public static String getCustomTagText(Optional<AppItemDto> appItem){
		String custom = appItem.get().getCustomTag();
		if(StringUtils.isBlank(custom)){
			return "";
		}
		String[] ss = custom.split(CUSTOMTAGSPLITSYMBOL);
		if(ss.length ==0){
			return "";
		}
		return ss[CUSTOMTAG_NO1];
	}
	/**
	 * 得到自有兑换项自定义角标的底色
	 * 不会返回null
	 * @param appItem
	 * @return
	 */
	public static String getCustomTagColor(Optional<AppItemDto> appItem){
		String custom = appItem.get().getCustomTag();
		if(StringUtils.isBlank(custom)){
			return "#fe4a21";
		}
		String[] ss = custom.split(CUSTOMTAGSPLITSYMBOL);
		if(ss.length < CUSTOMTAG_NO2+1){
			return "#fe4a21";
		}
		return ss[CUSTOMTAG_NO2];
	}
	
	/**
	 * getCustomTagS
	 * @param customTagText
	 * @param customTagColor
	 * @return
	 */
	public static String getCustomTag(String customTagText,String customTagColor) {
		return joiner.join(customTagText, customTagColor);
	}
}
