/**
 * Project Name:goods-center-api
 * File Name:RemotePCGSellerBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月19日下午8:05:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGSellerBackendService <br/>
 * Function: PCG 品牌黑名单维护服务 <br/>
 * Date:     2016年5月19日 下午8:05:28 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemotePCGSellerBackendService {
    
    /**
     * 
     * createSeller:创建一个品牌 <br/>
     *
     * @author xuhengfei
     * @param name 品牌名称
     * @param logo Logo
     * @param payload 权重
     * @return 品牌id
     * @since JDK 1.6
     */
    DubboResult<Long> createSeller(String name,String logo,Integer payload);
    /**
     * 
     * findAll:查询所有品牌 <br/>
     *
     * @author xuhengfei
     * @return 品牌结果集
     * @since JDK 1.6
     */
    DubboResult<List<PCGSellerDto>> findAll();
    
    
    /**
     * 设置商品到一个品牌
     *
     * @author xuhengfei
     * @param pcgId
     * @param sellerId
     * @param payload
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addGoods2Seller(long pcgId,long sellerId,Integer payload);
    /**
     * 将商品从一个品牌中删除
     *
     * @author xuhengfei
     * @param pcgId
     * @param sellerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> remoteGoodsFromSeller(long pcgId,long sellerId);
    
    /**
     * 删除一个品牌
     *
     * @author xuhengfei
     * @param sellerId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeSeller(long sellerId);
    
    /**
     * 编辑品牌
     *
     * @author xuhengfei
     * @param sellerId
     * @param name 名称
     * @param logo Logo
     * @param payload 权重
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> editSellerNamePlyloadAndLogo(long sellerId,String name,String logo,Integer payload);

    /**
     * 对分类进行排序(只更新payload字段，不更新其他字段)
     * @param sellers 需要排序的类目列表
     * @return
     */
    DubboResult<Boolean> sortSellers(List<PCGSellerDto> sellers);
    
    /**
     * 查找一个品牌下的所有商品
     *
     * @author xuhengfei
     * @param selllerId 品牌id 
     * @return 结果集
     * @since JDK 1.6
     */
    DubboResult<List<PCGSellerGoodsDto>> findAllBySellerId(long selllerId);
    /**
     * 对一个品牌下的商品进行排序
     *
     * @author xuhengfei
     * @param list 需要排序的品牌列表
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortSellerGoods(List<PCGSellerGoodsDto> list);
    
}

