package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 兑换项优惠券商品接口
 * 
 * @author houwen
 */
public interface RemoteItemCouponGoodsService {

	/**
	 * 领一张券
	 * 
	 * @param itemKeyDto
	 * @param consumerId
	 * @param bizNum
	 * @return
	 */
	public DubboResult<GoodsCouponDto> takeCoupon(ItemKeyDto itemKeyDto, Long consumerId, String bizNum);

	/**
	 * 确认完成一张券(在订单最终成功时来调用此方法)
	 * @param itemKeyDto
	 * @param couponId
	 * @param orderId
	 * @return
	 */
	public DubboResult<Boolean> completeCoupon(ItemKeyDto itemKeyDto, Long couponId, long orderId);

	/**
	 * 回滚一张券<br/>
	 * 如果先锁定一张券，最终订单失败了，需要调用此方法，将券回滚为 未使用 状态
	 * @param itemKeyDto
	 * @param couponId
	 * @param bizNum
	 * @return
	 */
	public DubboResult<Boolean> rollbackCoupon(ItemKeyDto itemKeyDto, Long couponId, String bizNum);

	/**
	 * 根据券码ID查询券码DTO
	 * @param itemKeyDto
	 * @param couponId
	 * @return
	 */
	public DubboResult<GoodsCouponDto> findCoupon(ItemKeyDto itemKeyDto, Long couponId);
	
	/**
	 * 查询商品当前批次
	 * @param itemKeyDto
	 * @return
	 */
	public DubboResult<GoodsBatchDto> findCurrentBatch(ItemKeyDto itemKeyDto);
	
	/**
	 * 根据批次ID查询批次
	 * @param itemKeyDto
	 * @param batchId
	 * @return
	 */
	public DubboResult<GoodsBatchDto> findCouponBatch(ItemKeyDto itemKeyDto, Long batchId);

}
