package cn.com.duiba.goods.center.api.remoteservice.item;

import java.util.Date;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemLimitDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 商品兑换限制
 */
public interface RemoteItemLimitService {

	/**
	 * 统计限量商品的兑换次数，内部使用count
	 * 
	 * @param itemKey
	 * @param startTime
	 * @return
	 */
	public DubboResult<Integer> countByItemKeyAndGmtCreate(String itemKey, Date startTime);

	/**
	 * 记录限量商品兑换明细
	 * 
	 * @param itemLimitDO
	 */
	public DubboResult<Void> insert(ItemLimitDto itemLimit);

	/**
	 * 删除限量商品兑换明细
	 * 
	 * @param itemKey
	 * @param consumerId
	 * @param orderId
	 * @param orderType
	 */
	public DubboResult<Integer> delete(String itemKey, long consumerId, long orderId, String orderType);

}
