/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemExtraDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ItemMarkEnum;
import org.apache.commons.lang.StringUtils;

public class ItemKeyUtils {
    private ItemKeyUtils() {
    }

    public static boolean isGoodsCoupon(ItemKeyDto itemKeyDto) {
        if (itemKeyDto.isSelfAppItemMode()) {
            return itemKeyDto.getAppItem().isOpTypeAppItem(16);
        }
        if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
            return itemKeyDto.getItem().isOpTypeItem(16);
        }
        return false;
    }

    public static Long getId(ItemKeyDto itemKey) {
        if (itemKey.getAppItem() != null) {
            if (itemKey.getAppItem().getId() == null) {
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getId();
                }
                return null;
            }
            return itemKey.getAppItem().getId();
        }
        return itemKey.getItem().getId();
    }

    public static String getType(ItemKeyDto itemKey) {
        if (itemKey.getAppItem() != null) {
            if (itemKey.getAppItem().getType() == null) {
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getType();
                }
                return null;
            }
            return itemKey.getAppItem().getType();
        }
        return itemKey.getItem().getType();
    }

    public static String getName(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getName();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getTitle();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank((String)itemKey.getAppItem().getTitle())) {
                return itemKey.getAppItem().getTitle();
            }
            return itemKey.getItem().getName();
        }
        return null;
    }

    public static String getSubtitle(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getSubtitle();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isBlank((String)itemKey.getAppItem().getSubtitle())) {
                return itemKey.getItem().getSubtitle();
            }
            return itemKey.getAppItem().getSubtitle();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getSubtitle();
        }
        return null;
    }

    public static String getTitle(ItemKeyDto itemKey) {
        if (itemKey.getAppItem() != null) {
            if (itemKey.getAppItem().getTitle() == null) {
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getName();
                }
                return null;
            }
            return itemKey.getAppItem().getTitle();
        }
        return itemKey.getItem().getName();
    }

    public static String getImage(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank((String)itemKey.getAppItem().getLogo())) {
                return itemKey.getAppItem().getImage();
            }
            return itemKey.getItem().getImage();
        }
        return null;
    }

    public static String getLogo(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getLogo();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getLogo();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank((String)itemKey.getAppItem().getLogo())) {
                return itemKey.getAppItem().getLogo();
            }
            return itemKey.getItem().getLogo();
        }
        return null;
    }

    public static String getThumbnailImage(ItemKeyDto itemKey, Integer imageStyle) {
        return ItemKeyUtils.getThumbnailImage(itemKey.getAppItem(), itemKey.getItem(), imageStyle);
    }

    public static String getThumbnailImage(AppItemDto appItem, ItemDto item, Integer imageStyle) {
        String smallImage = "";
        String whiteImage = "";
        if (item != null && appItem == null) {
            smallImage = item.getSmallImage();
            whiteImage = item.getWhiteImage();
        }
        if (item != null && appItem != null) {
            smallImage = StringUtils.isNotBlank((String)appItem.getSmallImage()) ? appItem.getSmallImage() : item.getSmallImage();
            String string = whiteImage = StringUtils.isNotBlank((String)appItem.getWhiteImage()) ? appItem.getWhiteImage() : item.getWhiteImage();
        }
        if (item == null && appItem != null) {
            smallImage = appItem.getSmallImage();
            whiteImage = appItem.getWhiteImage();
        }
        return ItemKeyUtils.getThumbnailImage(smallImage, whiteImage, imageStyle);
    }

    public static String getThumbnailImage(String smallImage, String whiteImage, Integer imageStyle) {
        String image = "";
        if (imageStyle == 0) {
            String string = image = StringUtils.isNotBlank((String)smallImage) ? smallImage : whiteImage;
        }
        if (imageStyle == 1) {
            image = StringUtils.isNotBlank((String)whiteImage) ? whiteImage : smallImage;
        }
        return StringUtils.isNotBlank((String)image) ? image : "//yun.duiba.com.cn/developer/img/default_img.jpg";
    }

    public static String getSmallImage(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getSmallImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getSmallImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank((String)itemKey.getAppItem().getSmallImage())) {
                return itemKey.getAppItem().getSmallImage();
            }
            return itemKey.getItem().getSmallImage();
        }
        return null;
    }

    public static String getSmallImageNew(ItemKeyDto itemKey) {
        String extraSmallNew;
        String smallImageNew = null;
        ItemExtraDto itemExtra = itemKey.getItem() == null ? null : itemKey.getItem().getItemExtraDto();
        String string = extraSmallNew = itemExtra == null ? null : itemExtra.getSmallImgNew();
        if (itemKey.isItemMode()) {
            smallImageNew = extraSmallNew;
        }
        if (itemKey.isSelfAppItemMode()) {
            smallImageNew = itemKey.getAppItem().getSmallImgNew();
        }
        if (itemKey.isDuibaAppItemMode()) {
            smallImageNew = itemKey.getAppItem().getSmallImgNew();
            smallImageNew = StringUtils.isNotBlank((String)smallImageNew) ? smallImageNew : extraSmallNew;
        }
        return StringUtils.isNotBlank((String)smallImageNew) ? smallImageNew : null;
    }

    public static String getBannerImage(ItemKeyDto itemKey) {
        String bannerImage = null;
        if (itemKey.isItemMode()) {
            bannerImage = itemKey.getItem().getBannerImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            bannerImage = itemKey.getAppItem().getBannerImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            bannerImage = StringUtils.isNotBlank((String)itemKey.getAppItem().getBannerImage()) ? itemKey.getAppItem().getBannerImage() : itemKey.getItem().getBannerImage();
        }
        return StringUtils.isNotBlank((String)bannerImage) ? bannerImage : null;
    }

    public static String getBannerImageNew(ItemKeyDto itemKey) {
        String extraBannerNew;
        String bannerImageNew = null;
        ItemExtraDto itemExtra = itemKey.getItem() == null ? null : itemKey.getItem().getItemExtraDto();
        String string = extraBannerNew = itemExtra == null ? null : itemExtra.getBannerImgNew();
        if (itemKey.isItemMode()) {
            bannerImageNew = extraBannerNew;
        }
        if (itemKey.isSelfAppItemMode()) {
            bannerImageNew = itemKey.getAppItem().getBannerImgNew();
        }
        if (itemKey.isDuibaAppItemMode()) {
            bannerImageNew = itemKey.getAppItem().getBannerImgNew();
            bannerImageNew = StringUtils.isNotBlank((String)bannerImageNew) ? bannerImageNew : extraBannerNew;
        }
        return StringUtils.isNotBlank((String)bannerImageNew) ? bannerImageNew : null;
    }

    public static String getDescription(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getDescription();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getDescription();
        }
        return null;
    }

    public static Double getPrice(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().getMarketPrice() != null) {
                return (double)itemKey.getItem().getMarketPrice().intValue() / 100.0;
            }
            return (double)itemKey.getItem().getFacePrice().intValue() / 100.0;
        }
        if (itemKey.isSelfAppItemMode()) {
            return (double)itemKey.getAppItem().getFacePrice().intValue() / 100.0;
        }
        return null;
    }

    public static String getStringItemKey(ItemKeyDto itemKey) {
        Long itemId = itemKey.getItem() != null ? itemKey.getItem().getId() : null;
        Long appItemId = itemKey.getAppItem() != null ? itemKey.getAppItem().getId() : null;
        return ItemKeyUtils.getStringItemKey(itemId, appItemId);
    }

    public static String getStringItemKey(Long itemId, Long appItemId) {
        String devItemId = appItemId == null ? "" : String.valueOf(appItemId);
        String duibaItemId = itemId == null ? "" : String.valueOf(itemId);
        StringBuilder sb = new StringBuilder();
        sb.append(devItemId).append("_").append(duibaItemId);
        return sb.toString();
    }

    public static Long getSalePrice(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() && null != itemKey.getItem().getSalePrice()) {
            return itemKey.getItem().getSalePrice();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (null != itemKey.getAppItem().getSalePrice()) {
                return itemKey.getAppItem().getSalePrice();
            }
            if (null != itemKey.getItem().getSalePrice()) {
                return itemKey.getItem().getSalePrice();
            }
        }
        if (itemKey.isSelfAppItemMode() && null != itemKey.getAppItem().getSalePrice()) {
            return itemKey.getAppItem().getSalePrice();
        }
        return null;
    }

    public static ItemMarkEnum getMarkType(ItemKeyDto itemKey) {
        if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(0) || itemKey.getItem().isOpTypeItem(0)) {
                return ItemMarkEnum.MARK_TIME;
            }
            if (itemKey.getAppItem().isOpTypeAppItem(9) || itemKey.getItem().isOpTypeItem(9)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isItemMode()) {
            if (itemKey.getItem().isOpTypeItem(0)) {
                return ItemMarkEnum.MARK_TIME;
            }
            if (itemKey.getItem().isOpTypeItem(9)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(9)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
            if (itemKey.getAppItem().isOpTypeAppItem(0)) {
                return ItemMarkEnum.MARK_TIME;
            }
            if (itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeSingleLottery || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeOperatingActivity || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeManualLottery || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeAppShakeLottery || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTiger || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTurntable || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameSanta || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameYearAward || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameGirl || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameJiong || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuestionAnswer || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuizz || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeNgame || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGuess) {
                return ItemMarkEnum.MARK_LOTTERY;
            }
        }
        return ItemMarkEnum.MARK_NORMAL;
    }

    public static boolean isOpTypeSwitchOn(ItemKeyDto itemKey, int opType) {
        if (itemKey.getItem() != null) {
            return itemKey.getItem().isOpTypeItem(opType);
        }
        if (itemKey.getAppItem() != null) {
            return itemKey.getAppItem().isOpTypeAppItem(opType);
        }
        return false;
    }

    public static Long getItemId(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getId();
        }
        if (itemKey.isSelfAppItemMode()) {
            return null;
        }
        return null;
    }

    public static Long getAppItemId(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return null;
        }
        if (itemKey.isSelfAppItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getAppItem().getId();
        }
        return null;
    }
}

